/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWUserInfo;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkTestDataField;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.util.Date;
import java.util.Vector;

public class VWTrkWorkObject
implements IVWPropertyChangeSource {
    private VWWorkObject m_workObject = null;
    private String m_wobNum = null;
    private int m_stepId = -1;
    private boolean m_bLockedThisSession = false;
    private VWTrkTestDataField[] m_dataFields = null;
    private Date m_dateReceived = null;
    private int m_status = 0;
    private VWTrkDataModel m_dataModel = null;
    private VWParticipant m_participant = null;
    private Integer m_boundUserId = null;
    private VWParticipant m_lockedUser = null;
    private VWParticipant m_currentUser = null;
    private String m_queueName = null;
    private int m_lockedStatus = -1;

    public VWTrkWorkObject(VWTrkDataModel dataModel, VWWorkObject workObject) throws VWException {
        this.m_dataModel = dataModel;
        this.m_workObject = workObject;
        this.m_participant = this.getParticipant();
        this.m_stepId = this.getWorkOrderId();
        this.m_queueName = this.getCurrentQueueName();
    }

    public VWStepElement fetchStepElement() throws VWException {
        VWStepElement stepElement = null;
        if (this.m_workObject == null) {
            return null;
        }
        try {
            stepElement = this.m_workObject.fetchStepElement();
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            this.notifyPropertyChange();
            stepElement = null;
            throw ex;
        }
        return stepElement;
    }

    public String getComment() throws VWException {
        if (this.m_workObject != null) {
            return this.m_workObject.getComment();
        }
        return new String();
    }

    public int getOccurrenceId() throws VWException {
        return VWTrkWorkObject.getOccurrenceId(this.m_workObject);
    }

    static int getOccurrenceId(VWWorkObject wob) throws VWException {
        Object obj;
        if (wob != null && (obj = wob.getFieldValue("F_Occurrence")) != null && obj instanceof Integer) {
            return (Integer)obj;
        }
        return -1;
    }

    public void setComment(String comment) throws VWException {
        if (this.m_workObject != null) {
            if (comment == null) {
                comment = new String();
            }
            this.m_workObject.setFieldValue("F_Comment", comment, true);
        }
    }

    public String getSelectedResponse() throws VWException {
        if (this.m_workObject != null) {
            return this.m_workObject.getSelectedResponse();
        }
        return new String();
    }

    public void setSelectedResponse(String response) throws VWException {
        if (this.m_workObject != null && response != null) {
            this.m_workObject.setSelectedResponse(response);
        }
    }

    public Date getDateReceived() throws VWException {
        if (this.m_workObject != null) {
            return this.m_workObject.getDateReceived();
        }
        return this.m_dateReceived;
    }

    public int getStatus() {
        if (this.m_workObject != null) {
            // empty if block
        }
        return this.m_status;
    }

    public VWParticipant getParticipant() throws VWException {
        if (this.m_workObject != null) {
            return this.m_workObject.getParticipantNamePx();
        }
        return this.m_participant;
    }

    public String getCurrentQueueName() throws VWException {
        if (this.m_workObject != null) {
            return this.m_workObject.getCurrentQueueName();
        }
        return null;
    }

    public boolean getIsTracker() throws VWException {
        if (this.m_workObject != null) {
            return this.m_workObject.getIsTracker();
        }
        return false;
    }

    public boolean getIsAltered() throws VWException {
        if (this.m_workObject != null) {
            return this.m_workObject.getIsAltered();
        }
        return false;
    }

    public void doComplete(String response, String comments) throws VWException {
        if (this.m_workObject != null) {
            try {
                if (comments != null) {
                    this.m_workObject.setFieldValue("F_Comment", comments, true);
                }
                if (response != null) {
                    this.m_workObject.setSelectedResponse(response);
                }
                this.doDispatch();
            }
            catch (VWException ex) {
                throw ex;
            }
            finally {
                this.unlocked();
                this.m_workObject = null;
                this.removeReferences();
            }
        }
    }

    public void doDispatch() throws VWException {
        if (this.m_workObject != null) {
            try {
                this.m_workObject.doDispatch();
            }
            catch (VWException ex) {
                throw ex;
            }
            finally {
                this.unlocked();
                this.m_workObject = null;
                this.removeReferences();
            }
        }
    }

    public void doSave(boolean bUnlock) throws VWException {
        if (this.m_workObject != null) {
            try {
                this.m_workObject.doSave(bUnlock);
            }
            catch (VWException ex) {
                this.notifyPropertyChange();
                throw ex;
            }
            this.doRefresh(!bUnlock, !bUnlock);
        }
    }

    public void doReassign(VWParticipant participant, boolean deleteFlag, String queueName) throws VWException {
        if (this.m_workObject != null) {
            try {
                this.m_workObject.doReassignByDomain(participant.getDomainName(), participant.getParticipantName(), deleteFlag, queueName);
            }
            catch (VWException ex) {
                throw ex;
            }
            finally {
                this.unlocked();
            }
        }
    }

    public void doRefresh(boolean bLock, boolean bOverrideLock) throws VWException {
        if (this.m_workObject != null) {
            try {
                this.m_workObject.doRefresh(bLock, bOverrideLock);
            }
            catch (VWException ex) {
                this.notifyPropertyChange();
                throw ex;
            }
            finally {
                this.unlocked();
                this.m_bLockedThisSession = bLock;
            }
        }
    }

    public void doReturnToSource() throws VWException {
        if (this.m_workObject != null) {
            try {
                this.m_workObject.doReturnToSource();
            }
            catch (VWException ex) {
                throw ex;
            }
            finally {
                this.unlocked();
                this.m_workObject = null;
                this.removeReferences();
            }
        }
    }

    public Date getDeadline() {
        if (this.m_workObject != null) {
            try {
                return this.m_workObject.getDeadline();
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
        return null;
    }

    public int getOverdue() {
        if (this.m_workObject != null) {
            try {
                return this.m_workObject.getOverdue();
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
        return -1;
    }

    public VWTrkTestDataField[] getDataFields() throws VWException {
        VWDataField[] dataFields;
        if (this.m_workObject != null && (dataFields = this.m_workObject.getDataFields(767, 1)) != null && dataFields.length > 0) {
            this.m_dataFields = new VWTrkTestDataField[dataFields.length];
            for (int i = 0; i < dataFields.length; ++i) {
                this.m_dataFields[i] = new VWTrkTestDataField(this.m_workObject, dataFields[i], this.getFieldDefinition(dataFields[i].getName()));
            }
        }
        return this.m_dataFields;
    }

    public VWWorkObject getVWWorkObject() {
        return this.m_workObject;
    }

    public void doLock(boolean bOverrideLock) throws VWException {
        if (this.m_workObject != null) {
            if (!this.isLockedByCurrentUser()) {
                this.doRefresh(false, false);
                if (this.m_stepId != this.m_workObject.getWorkOrderId() || VWStringUtils.compare(this.m_queueName, this.m_workObject.getCurrentQueueName()) != 0 || this.m_participant != null && VWStringUtils.compare(this.m_participant.getParticipantName(), this.m_workObject.getParticipantName()) != 0) {
                    this.notifyPropertyChange();
                    return;
                }
            }
            try {
                this.m_workObject.doLock(bOverrideLock);
                this.m_bLockedThisSession = true;
                this.m_lockedStatus = 1;
            }
            catch (VWException ex) {
                this.m_lockedStatus = -1;
                this.fetchLockedStatus();
                if (this.isLockedByCurrentUser()) {
                    return;
                }
                throw ex;
            }
        }
    }

    public VWException[] doUnlockMany(VWTrkWorkObject[] workObjects, boolean bSave, boolean bDispatch) throws VWException {
        if (workObjects == null) {
            return null;
        }
        int count = workObjects.length;
        if (count == 0) {
            return null;
        }
        VWWorkObject vwWorkObject = workObjects[0].getVWWorkObject();
        if (vwWorkObject != null) {
            VWWorkObject[] vwWorkObjects = new VWWorkObject[count];
            for (int i = 0; i < count; ++i) {
                VWTrkWorkObject workObject = workObjects[i];
                if (workObject == null) continue;
                vwWorkObjects[i] = workObjects[i].getVWWorkObject();
                this.unlocked();
            }
            VWException[] ex = VWWorkObject.doUnlockMany(vwWorkObjects, bSave, bDispatch);
            if (ex != null) {
                for (int i = 0; i < ex.length; ++i) {
                    if (ex[i] == null) continue;
                    this.notifyPropertyChange();
                    break;
                }
            }
            return ex;
        }
        return null;
    }

    VWFieldDefinition getFieldDefinition(String name) {
        if (this.m_dataModel != null) {
            return this.m_dataModel.getFieldDefinition(name);
        }
        return null;
    }

    public String[] getFieldNames() {
        if (this.m_workObject != null) {
            return this.m_workObject.getFieldNames();
        }
        if (this.m_dataFields == null || this.m_dataFields.length == 0) {
            return null;
        }
        String[] names = new String[this.m_dataFields.length];
        for (int i = 0; i < this.m_dataFields.length; ++i) {
            names[i] = this.m_dataFields[i].getName();
        }
        return names;
    }

    public Object getFieldValue(String name) throws VWException {
        if (this.m_workObject != null) {
            return this.m_workObject.getFieldValue(name);
        }
        if (this.m_dataFields == null || this.m_dataFields.length == 0) {
            return null;
        }
        for (int i = 0; i < this.m_dataFields.length; ++i) {
            String fieldName = this.m_dataFields[i].getName();
            if (VWStringUtils.compare(fieldName, name) != 0) continue;
            return fieldName;
        }
        return null;
    }

    public void setFieldValue(String name, Object value) throws VWException {
        VWTrkTestDataField dataField = null;
        boolean bCompare = true;
        if (this.m_workObject != null) {
            if (this.isLockedByCurrentUser() && !this.m_bLockedThisSession) {
                this.doLock(true);
            }
            if (this.m_dataFields == null || this.m_dataFields.length == 0) {
                return;
            }
            if (this.m_dataFields != null || this.m_dataFields.length != 0) {
                for (int i = 0; i < this.m_dataFields.length; ++i) {
                    String fieldName = this.m_dataFields[i].getName();
                    if (VWStringUtils.compare(fieldName, name) != 0) continue;
                    dataField = this.m_dataFields[i];
                    break;
                }
            }
            if (dataField != null) {
                Object obj;
                bCompare = dataField.getMergeType() != 6;
                dataField.setValue(value, bCompare);
                Object newValue = obj = dataField.getValue();
                newValue = obj = this.m_workObject.getFieldValue(name);
            }
        }
    }

    public String getOperationName() throws VWException {
        if (this.m_workObject != null) {
            return this.m_workObject.getOperationName();
        }
        return new String();
    }

    public void doTerminate() throws VWException {
        if (this.m_workObject != null) {
            try {
                this.m_workObject.doTerminate();
                this.m_workObject = null;
                this.removeReferences();
            }
            catch (VWException ex) {
                this.notifyPropertyChange();
                throw ex;
            }
            finally {
                this.unlocked();
            }
        }
    }

    public VWParticipant getLockedUser() throws VWException {
        if (this.m_workObject != null) {
            VWParticipant lockedUser = this.m_workObject.getLockedUserPx();
            VWParticipant currentUser = this.getCurrentUser();
            String lockedUserName = null;
            String currentUserName = null;
            if (lockedUser != null && (lockedUserName = lockedUser.getParticipantName()) != null && lockedUserName.length() == 0) {
                lockedUserName = null;
            }
            if (currentUser != null && (currentUserName = currentUser.getParticipantName()) != null && currentUserName.length() == 0) {
                currentUserName = null;
            }
            if (lockedUserName == null || currentUserName == null || !VWStringUtils.compareUsers(lockedUserName, currentUserName)) {
                this.m_bLockedThisSession = false;
            }
            return lockedUser;
        }
        return this.m_lockedUser;
    }

    private int fetchLockedStatus() throws VWException {
        if (this.m_workObject != null) {
            try {
                this.m_lockedStatus = this.m_workObject.fetchLockedStatus();
                if (this.m_lockedStatus != 1) {
                    this.m_bLockedThisSession = false;
                }
            }
            catch (VWException ex) {
                this.notifyPropertyChange();
                throw ex;
            }
        }
        return this.m_lockedStatus;
    }

    public int getLockedStatus() throws VWException {
        if (this.m_workObject != null && this.m_lockedStatus == -1) {
            return this.fetchLockedStatus();
        }
        if (this.m_lockedStatus == -1) {
            return 0;
        }
        return this.m_lockedStatus;
    }

    public boolean isLockedByCurrentUser() {
        try {
            int vwLockStatus = this.getLockedStatus();
            boolean bLockedByCurrentUser = false;
            if (vwLockStatus == 1) {
                VWParticipant currentUser = this.getCurrentUser();
                VWParticipant lockedUser = this.getLockedUser();
                if (lockedUser != null && currentUser != null && VWStringUtils.compareUsers(lockedUser.getParticipantName(), currentUser.getParticipantName())) {
                    return true;
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    public String getWorkObjectNumber() {
        if (this.m_workObject != null) {
            try {
                return this.m_workObject.getWorkObjectNumber();
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
        return this.m_wobNum;
    }

    public int getWorkOrderId() throws VWException {
        if (this.m_workObject != null) {
            return this.m_workObject.getWorkOrderId();
        }
        return this.m_stepId;
    }

    private VWParticipant getCurrentUser() {
        VWParticipant currentUser = null;
        try {
            VWUserInfo userInfo = VWDefaultSessionProxy.fetchCurrentUserInfo();
            if (userInfo != null) {
                currentUser = userInfo.getNamePx();
                userInfo = null;
            }
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return currentUser;
    }

    protected void unlocked() {
        this.m_lockedStatus = -1;
        this.m_bLockedThisSession = false;
    }

    public void notifyPropertyChange() {
        this.m_dataModel.setNeedRefresh(true);
        VWPropertyChangeNotifier.notifyPropertyChange(new VWPropertyChangeEvent(this, 709));
    }

    public Vector getItemsChanged() {
        Vector<VWTrkWorkObject> vector = new Vector<VWTrkWorkObject>();
        vector.addElement(this);
        return vector;
    }

    public void removeReferences() {
        if (this.m_dataFields != null) {
            for (int i = this.m_dataFields.length - 1; i >= 0; --i) {
                this.m_dataFields[i].removeReferences();
                this.m_dataFields[i] = null;
            }
            this.m_dataFields = null;
        }
    }
}

